import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create a figure and axis
fig, ax = plt.subplots(figsize=(8, 10))

# Define colors
floor_color = 'lightgrey'
passenger_color = 'blue'
fast_elevator_color = 'green'
slow_elevator_color = 'green'
full_capacity_color = 'red'

# Define floor positions and sizes
floor_height = 1
floor_width = 6
num_floors = 5
floor_gap = 1.5  # Gap between floors

# Draw floors
for i in range(num_floors):
    ax.add_patch(patches.Rectangle((0, i * floor_gap), floor_width, floor_height, color=floor_color))
    ax.text(0.5, i * floor_gap + 0.5, f'floor_{i}', fontsize=10, va='center', ha='left', color='black')

# Draw passengers
passengers = {
    'p2': (0, 0), 'p3': (0.5, 0),
    'p0': (0, 1), 'p5': (0.5, 1),
    'p1': (0, 3), 'p4': (0.5, 3)
}

for p, (x_offset, floor) in passengers.items():
    ax.add_patch(patches.Rectangle((x_offset, floor * floor_gap + 0.25), 0.2, 0.5, color=passenger_color))
    ax.text(x_offset + 0.1, floor * floor_gap + 0.5, p, fontsize=8, va='center', ha='center', color='white')

# Draw elevators
elevators = {
    'fast0': (5, 0, fast_elevator_color, '0/2 passengers'),
    'fast1': (5.5, 0, fast_elevator_color, '0/2 passengers'),
    'slow0-0': (4.5, 0, slow_elevator_color, '0/1 passengers'),
    'slow1-0': (4.5, 2, slow_elevator_color, '0/1 passengers')
}

for e, (x, floor, color, status) in elevators.items():
    ax.add_patch(patches.Rectangle((x, floor * floor_gap + 0.25), 0.4, 0.5, color=color))
    ax.text(x + 0.2, floor * floor_gap + 0.5, f'{e}\n{status}', fontsize=8, va='center', ha='center', color='white')

# Add legend
legend_patches = [
    patches.Patch(color=passenger_color, label='Passenger'),
    patches.Patch(color=fast_elevator_color, label='Fast Elevator'),
    patches.Patch(color=slow_elevator_color, label='Slow Elevator'),
    patches.Patch(color=full_capacity_color, label='Full Capacity')
]
ax.legend(handles=legend_patches, loc='upper left', bbox_to_anchor=(1, 1))

# Set limits and remove axes
ax.set_xlim(-0.5, 7)
ax.set_ylim(-0.5, num_floors * floor_gap)
ax.axis('off')

# Save the figure
plt.savefig('elevator/one_shot/ini_diagram_code/attempts/attempt_26.png', bbox_inches='tight')
plt.show()